% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{msharpe}
\alias{msharpe}
\title{Compute modified Sharpe ratio}
\usage{
msharpe(X, level = 0.9, na.rm = TRUE, na.neg = TRUE)
}
\arguments{
\item{X}{Vector (of lenght \eqn{T}) or matrix (of size \eqn{T \times
N}{TxN}) of returns.  \code{NA} values are allowed.}

\item{level}{Modified Value-at-Risk level. Default: \code{level = 0.90}.}

\item{na.rm}{A logical value indicating whether \code{NA} values should be
stripped before the computation. Default \code{na.rm = TRUE}.}

\item{na.neg}{A logical value indicating whether \code{NA} values should be
returned if a negative modified Value-at-Risk is obtained.  Default
\code{na.neg = TRUE}.}
}
\value{
Scalar or a vector (of size \eqn{N}) with the modified Sharpe
ratios.
}
\description{
Function which computes the modified Sharpe ratio
}
\details{
The modified Sharpe ratio (Favre and Galeano 2002) is one industry
standard for measuring the absolute risk adjusted performance of hedge
funds.
}
\examples{
## Load the data (randomized data of monthly hedge fund returns)
data('hfdata')

out = msharpe(hfdata)
print(out)

out = msharpe(hfdata, na.rm = FALSE)
print(out)
}
\author{
David Ardia and Kris Boudt.
}
\references{
Ardia, D., Boudt, K. (2015).  
Testing equality of modified Sharpe ratios.
\emph{Finance Research Letters} \bold{13}, pp.97--104. 
\doi{10.1016/j.frl.2015.02.008}

Ardia, D., Boudt, K. (2016).  
The Peer Ratios Performance of Hedge Funds. 
\emph{Working paper}.
\doi{10.2139/ssrn.2000901}

Favre, L., Galeano, J.A. (2002).  
Mean-modified Value-at-Risk Optimization with Hedge Funds.  
\emph{Journal of Alternative Investments} \bold{5}(2), pp.21--25.
\doi{10.3905/jai.2002.319052}

Gregoriou, G. N., Gueyie, J.-P. (2003).  
Risk-adjusted performance of funds of hedge funds using a modified Sharpe ratio.  
\emph{Journal of Wealth Management} \bold{6}(3), pp.77--83.
\doi{10.3905/jwm.2003.442378}
}
\seealso{
\code{\link{msharpeTesting}}, \code{\link{msharpeScreening}} and
\code{\link{sharpe}}.
}
\keyword{htest}

