% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/conductance.R
\name{valueConverter}
\alias{valueConverter}
\title{win-loss probability matrix value converter}
\usage{
valueConverter(matrix)
}
\arguments{
\item{matrix}{the win-loss matrix which is the second output from \code{conductance}.}
}
\value{
a matrix of win-loss probability ranging from 0.5 - 1.0.
}
\description{
\code{valueConverter} converts or transforms all values (which range from 0.0 to 1.0)
 in the win-loss probability matrix into 0.5 - 1.0
}
\examples{
# convert an edgelist to conflict matrix
confmatrix <- as.conflictmat(sampleEdgelist)
# find win-loss probability matrix
perm2 <- conductance(confmatrix, 2)
perm2$imputed.conf
perm2$p.hat
convertedValue <- valueConverter(perm2$p.hat)
}
\seealso{
\code{\link{conductance}}, \code{\link{individualDomProb}}, \code{\link{dyadicLongConverter}}
}

