% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohortDiagnostics.R
\name{cohortDiagnostics}
\alias{cohortDiagnostics}
\title{Run cohort-level diagnostics}
\usage{
cohortDiagnostics(cohort, survival = FALSE, match = TRUE, matchedSample = 1000)
}
\arguments{
\item{cohort}{Cohort table in a cdm reference}

\item{survival}{Boolean variable. Whether to conduct survival analysis (TRUE) or not (FALSE).}

\item{match}{Boolean variable. Whether to conduct the analysis for the matched cohorts (TRUE) or not (FALSE).}

\item{matchedSample}{Only if match = TRUE. The number of people to take a random sample for
matching. If NULL, no sampling will be performed.}
}
\value{
A summarised result
}
\description{
Runs phenotypeR diagnostics on the cohort.
The diganostics include:
* Age groups and sex summarised.
* A summary of visits of everyone in the cohort using visit_occurrence table.
* A summary of age and sex density of the cohort.
* Attritions of the cohorts.
* Overlap between cohorts (if more than one cohort is being used).
}
\examples{
\donttest{
library(PhenotypeR)

cdm <- mockPhenotypeR()

result <- cohortDiagnostics(cdm$my_cohort,
                            match = TRUE)

CDMConnector::cdmDisconnect(cdm = cdm)
}
}
