% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\name{check_dimensions}
\alias{check_dimensions}
\title{Check dimensions of the parameters}
\usage{
check_dimensions(p, root.state, shifts, variance, selection.strength = NULL,
  optimal.value = NULL)
}
\arguments{
\item{p}{dimention of the trait simulated}

\item{root.state}{(list) state of the root, with:
random : random state (TRUE) or deterministic state (FALSE)
value.root : if deterministic, value of the character at the root
exp.root : if random, expectation of the character at the root
var.root : if random, variance of the character at the root}

\item{shifts}{(list) position and values of the shifts :
edges : vector of the K id of edges where the shifts are
values : matrix p x K of values of the shifts on the edges (one column = one shift)
relativeTimes : vector of dimension K of relative time of the shift from the
parentnode of edges}

\item{variance}{variance-covariance matrix size p x p}

\item{optimal.value}{vector of p optimal values at the root (OU)}

\item{selection.strenght}{matrix of selection strength size p x p (OU)}
}
\value{
Nothing
}
\description{
\code{check_dimensions} checks dimensions of the parameters. 
If wrong, throw an error.
}
\keyword{internal}

