% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_internal}
\alias{simulate_internal}
\title{Simulate a Stochastic Process on a tree}
\usage{
simulate_internal(
  phylo,
  process = c("BM", "OU", "scOU", "OUBM", "StudentOU"),
  p = 1,
  root.state = list(random = FALSE, stationary.root = FALSE, value.root = NA, exp.root
    = NA, var.root = NA),
  shifts = list(edges = NULL, values = NULL, relativeTimes = NULL),
  eps = 10^(-6),
  selection.strength = NULL,
  variance = NULL,
  optimal.value = NULL,
  checks = TRUE,
  simulate_random = TRUE,
  U_tree = NULL,
  times_shared = NULL,
  df = 1
)
}
\arguments{
\item{phylo}{a phylogenetic tree, class \code{\link[ape]{phylo}}.}

\item{process}{The model used for the simulation. One of "BM" (for a full BM
model, univariate or multivariate); "OU" (for a full OU model, univariate or
multivariate); or "scOU" (for a "scalar OU" model).}

\item{p}{Dimension of the simulated trait}

\item{root.state}{List describing the state of the root, with:
\describe{
 \item{random}{random state (TRUE) or deterministic state (FALSE)}
 \item{value.root}{if deterministic, value of the character at the root}
 \item{exp.root}{if random, expectation of the character at the root}
 \item{var.root}{if random, variance of the character at the root (pxp matrix)}
 }}

\item{shifts}{List with position and values of the shifts :
\describe{
 \item{edges}{vector of the K id of edges where the shifts are}
 \item{values}{matrix p x K of values of the shifts on the edges
  (one column = one shift)}
 \item{relativeTimes}{vector of dimension K of relative time of the shift from the parent node of edges}
 }}

\item{eps}{Tolerance for the value of the norm 1 of the selection strength matrix for OU}

\item{selection.strength}{Matrix of selection strength size p x p (OU)}

\item{variance}{Variance-covariance matrix size p x p}

\item{optimal.value}{Vector of p optimal values at the root (OU)}

\item{checks}{whether to check the entry parameters for consistency. Default 
to TRUE.}

\item{simulate_random}{set to FALSE if only the expected values are needed
(and not the random sample). Default to TRUE.}

\item{U_tree}{optional, full incidence matrix of the tree, result of function
\code{incidence.matrix.full}.}

\item{times_shared}{optional, times of shared ancestry of all nodes and tips,
result of function \code{\link{compute_times_ca}}. Can be specified to avoid extra
computations.}

\item{df}{if the process is "StudentOU", the number of degree of freedom of
the chosen student law. default to 1.}
}
\value{
paramSimu An array with dimensions p x Nnode x 2 (BM)
 or p x Nnode x 3 (OU). For each trait t, 1 <= t <= p, paramSimu[t, , ] has
 tree columns, containing respectively the simulated state,
 expected value and optimal value for all the nodes.
}
\description{
\code{simulate_internal} simulate a stochastic process on a tree.
}
\keyword{internal}
