% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryActigraph.R
\name{queryActigraph}
\alias{queryActigraph}
\title{Query ActiGraph File}
\usage{
queryActigraph(datfile, qry)
}
\arguments{
\item{datfile}{An AGD file.}

\item{qry}{An SQL SELECT statement.}
}
\value{
A data frame with query results.
}
\description{
This function executes a SELECT query on an ActiGraph AGD file.
}
\details{
AGD files are actually SQLite databases.  This function requires the
\pkg{RSQLite} package.  The user is encouraged to directly interface with
the database by creating a connection with the \pkg{DBI} package.  This has
been tested with AGD files produced with ActiLife v6.11.
}
\examples{
\dontrun{
dat <- queryActigraph("actfile.agd", "SELECT * FROM data LIMIT 5")

queryActigraph("actfile.agd", "SELECT * FROM settings")

## directly interface using DBI package
con <- DBI::dbConnect(RSQLite::SQLite(), "actfile.agd")
DBI::dbListTables(con)
DBI::dbDisconnect(con)
}
}
\seealso{
\code{\link{readActigraph}}
}
\author{
Cole Beck \email{cole.beck@vumc.org}
}
