% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choices.R
\name{choices}
\alias{choices}
\title{Choices Object}
\usage{
choices(rankings, names = FALSE)
}
\arguments{
\item{rankings}{a \code{"\link{rankings}"} object, or an object that can be
coerced by \code{as.rankings}.}

\item{names}{logical: if \code{TRUE} use the object names in the returned
\code{"choices"} object, else use object indices.}
}
\value{
A data frame of class \code{"choices"} with elements:
\item{choices}{ A list where each element represents the set of items
chosen for a single rank in the ranking.}
\item{alternatives}{ A list where each element represents the set of items
to choose from for a single rank in the ranking.}
\item{ranking}{ A list where each element represents the ranking that the
choice belongs to.}
The list stores the number of choices and the names of the objects as the
attributes \code{"nchoices"} and \code{"objects"} respectively.
}
\description{
Convert a set of rankings to a list of choices, alternatives, and
rankings. The choices and the corresponding alternatives make up the
exchangeable part of the Plackett-Luce with ties.
}
\examples{
R <- matrix(c(1, 2, 0, 0,
              4, 1, 2, 3,
              2, 1, 1, 1,
              1, 2, 3, 0,
              2, 1, 1, 0,
              1, 0, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) <- c("apple", "banana", "orange", "pear")

actual_choices <- choices(R, names = TRUE)
actual_choices[1:6,]

coded_choices <- choices(R, names = FALSE)
coded_choices[1:2,]
as.data.frame(coded_choices)[1:2,]
attr(coded_choices, "objects")

}
