% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{burden}
\alias{burden}
\title{Calculate burden based on how different learning assumptions affect portfolio size}
\usage{
burden(M, nI, nT, learning, weight_by = "instrument")
}
\arguments{
\item{M}{Matrix with the policy portfolio, where the first dimension contains instruments and the second contains targets.}

\item{nI}{Integer with the number of Instruments.}

\item{nT}{Integer with the number of Targets.}

\item{learning}{The assumption of the decay of learning. It is either "continuous" (arithmetical decay), "steep" (geometrical decay) or "capped" (sudden decay and constant hereafter).}

\item{weight_by}{By default learning assumptions are done on different instrument levels ("instrument"). But it is also possible to use Target levels when using "target".}
}
\value{
A value of burden (portfolio size using a different learning assumption).
}
\description{
Internal function to calculate a transformation of portfolio size based on a
non-regular assumption of how policy learning works at the instrument level.
This generates a weighted portfolio size that can be understood as the
"burden" of its size.
}
\details{
- Arithmetical: assumes a continuous learning.
- Geometrical: assumes steep learning.
- Radical: assumes capped learning.

This contrasts with the regular portfolio size that assumes no learning is
produced between policy instruments.
}
