% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoloniexPublic.R
\docType{methods}
\name{ReturnChartData,PoloniexPublicAPI-method}
\alias{ReturnChartData,PoloniexPublicAPI-method}
\title{Fetch OHLC and volume timeseries data for a specific market.
The caller must specify a date range interval
and datafrequency for the requested timeseries.}
\usage{
\S4method{ReturnChartData}{PoloniexPublicAPI}(theObject, pair = "USDT_BTC",
  from = as.POSIXct("2014-01-01 00:00:00 UTC"),
  to = as.POSIXct("2018-01-01 00:00:00 UTC"), period = "4H")
}
\arguments{
\item{theObject}{The object on which the function should be called.}

\item{pair}{a length-one character vector - The currencypair
for which timeseries information should be fetched.}

\item{from}{POSIXct - Starting timestamp for
daterange interval.}

\item{to}{POSIXct - Ending timestamp for daterange interval.}

\item{period}{length-one character vector OR length-one
numeric vector - datafrequency for requested timeseries.
 if is(period, "numeric"): 300 / 900 / 1800 / 7200 / 14400 / 86400
 if is(period, "character"): "5M", "15M", "30M", "2H", "4H", "D"}
}
\value{
an xts timeseries object.
 rows    - ohcl and volume information for one timestamp.
 columns - high, low, open, close, volume, quotevolume,
  weightedaverage.
}
\description{
Fetch OHLC and volume timeseries data for a specific market.
The caller must specify a date range interval
and datafrequency for the requested timeseries.
}
\examples{
Sys.setenv(tz = "UTC")
poloniex.public <- PoloniexPublicAPI()
pair    <- "BTC_NXT"
from    <- as.POSIXct("2010-01-01 00:00:00 UTC")
to      <- as.POSIXct("2012-04-09 00:00:00 UTC")
period  <- "4H"

chart.data <- ReturnChartData(theObject = poloniex.public,
                              pair      = pair,
                              from      = from,
                              to        = to,
                              period    = period)
}
