% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoloniexTrading.R
\docType{methods}
\name{ReturnCompleteBalances,PoloniexTradingAPI-method}
\alias{ReturnCompleteBalances,PoloniexTradingAPI-method}
\title{Returns all of your account balances, including available balance, balance on orders,
and the estimated BTC value of your balance.
By default, this call is limited to your exchange account; set the all.balances input parameter to TRUE
to include your margin and lending accounts.}
\usage{
\S4method{ReturnCompleteBalances}{PoloniexTradingAPI}(theObject,
  all.balances = FALSE)
}
\arguments{
\item{theObject}{The Trading client API object on which the function should be called.}

\item{all.balances}{logical - set to TRUE to also return margin and lending
account balances.}
}
\value{
todo
}
\description{
Returns all of your account balances, including available balance, balance on orders,
and the estimated BTC value of your balance.
By default, this call is limited to your exchange account; set the all.balances input parameter to TRUE
to include your margin and lending accounts.
}
\examples{
\dontrun{
poloniex.trading <- PoloniexTradingAPI(your.key, your.secret)
balances         <- ReturnCompleteBalances(poloniex.trading)
head(balances)

balances.all <- ReturnCompleteBalances(poloniex.trading)
head(balances.all)
}
}
