% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoloniexPublic.R
\docType{methods}
\name{ReturnOrderBook,PoloniexPublicAPI-method}
\alias{ReturnOrderBook,PoloniexPublicAPI-method}
\title{Returns the order book for a given market,
as well as a sequence number for use with the Push API
and an indicator specifying whether the market is frozen.}
\usage{
\S4method{ReturnOrderBook}{PoloniexPublicAPI}(theObject, pair = "all",
  depth = 10)
}
\arguments{
\item{theObject}{The public client API object on which the function should be called.}

\item{pair}{length one-character vector - The currencypair
for which orderbook information should be fetched.
You may set pair to "all" to fetch the order books of all markets.}

\item{depth}{numeric - depth of the orderbook.}
}
\value{
A list containing orderbook information.

 if pair == "all": a list containing orderbook
  information for all available markets.
  Each list entry contains information for one
  specific market.
 if !pair == "all": a list containing orderbook
  information for the requested markets.

 Each market list contains following fields:
  - ask: Orderbook sell side, Dataframe containing
         ask prices and corresponding amounts.
  - bid: Orderbook buy side. Dataframe containing
         bid prices and corresponding amounts.
  - frozen: indicator specifying wheather market
            is frozen or not.
  - seq: Sequence number for Push API.
}
\description{
Returns the order book for a given market,
as well as a sequence number for use with the Push API
and an indicator specifying whether the market is frozen.
}
\examples{
poloniex.public <- PoloniexPublicAPI()

pair <- "BTC_NXT"
depth <- 2
order.book <- ReturnOrderBook(poloniex.public,
                              pair  = pair,
                              depth = depth)
order.book$bid
order.book$ask
order.book$frozen
order.book$seq

pair <- "all"
depth <- 2
order.book <- ReturnOrderBook(poloniex.public,
                              pair  = pair,
                              depth = depth)

names(order.book)
order.book$BTC_ETH$ask
}
