% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolynomF.R
\name{tangent}
\alias{tangent}
\title{Tangent lines}
\usage{
tangent(p, x0)
}
\arguments{
\item{p}{A polynomial object}

\item{x0}{A numeric vector of values at which the tangent line(s) are required}
}
\value{
A linear polynomial giving the tangent line, or a list of such polynomials
}
\description{
Find the tangent line to a polynomial at one or more x-points
}
\examples{
p <- poly.from.zeros(c(0, 0:5, 4))
plot(p, xlab = expression(italic(x)), ylab = expression(italic(P(x))),
  main = parse(text = paste("italic(P(x) ==",
                             as.character(p, decreasing = TRUE),")")))
x0 <- solve(deriv(p))        ## stationary points
lines(tangent(p, x0), col = "dark green", lty = "solid",
      limits = cbind(x0-1/4, x0+1/4))
points(x0, p(x0), col = "dark green")

x0 <- solve(deriv(deriv(p))) ## points of inflexion
lines(tangent(p, x0), col = "red", lty = "solid", lwd = 2,
      limits = cbind(x0-1/4, x0+1/4))
points(x0, p(x0), col = "red")
legend("bottomleft", c("Stationary points", "Points of inflexion"),
       pch = 19, col = c("dark green", "red"), lty = "solid",
       cex = 0.7, bg = "beige", box.lwd = 0.25)
}
