% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.factor.model.R
\name{covarianceMF}
\alias{covarianceMF}
\title{Covariance Matrix Estimate}
\usage{
covarianceMF(beta, stockM2, factorM2)
}
\arguments{
\item{beta}{(N x k) matrix of factor loadings (i.e. the betas) from a 
statistical factor model}

\item{stockM2}{vector of length N of the variance (2nd moment) of the 
model residuals (i.e. idiosyncratic variance of the stock)}

\item{factorM2}{(k x k) matrix of the covariance (2nd moment) of the factor 
realizations from a statistical factor model}
}
\value{
(N x N) covariance matrix
}
\description{
Estimate covariance matrix using a statistical factor model
}
\details{
This function estimates an (N x N) covariance matrix from a statistical 
factor model with k factors, where N is the number of assets.
}
