% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{weight_by_risk_parity}
\alias{weight_by_risk_parity}
\title{Risk Parity Weighting Suite}
\usage{
weight_by_risk_parity(
  selected_df,
  prices_df,
  method = c("inverse_vol", "equal_risk", "max_div"),
  lookback_periods = 252,
  min_periods = 60
)
}
\arguments{
\item{selected_df}{Binary selection matrix (data.frame with Date column)}

\item{prices_df}{Price data for risk calculations (typically daily)
Returns are calculated internally from prices}

\item{method}{Optimization method for risk parity}

\item{lookback_periods}{Number of periods for risk estimation (default: 252)}

\item{min_periods}{Minimum periods required (default: 60)}
}
\value{
Weight matrix with same dates as selected_df, rows sum to 1
}
\description{
Collection of risk-based weighting methods for portfolio construction.
Each method allocates capital based on risk characteristics rather than
market capitalization or arbitrary equal weights.
}
\details{
Methods:
\itemize{
\item inverse_vol: Weight inversely to volatility (1/'). Lower volatility
stocks receive higher weights. Simple but effective.
\item equal_risk: Equal Risk Contribution (ERC). Each position contributes
equally to total portfolio risk. Uses iterative optimization.
\item max_div: Maximum Diversification Portfolio. Maximizes the ratio of
weighted average volatility to portfolio volatility.
}

The function accepts price data and calculates returns internally,
ensuring consistency with other library functions. Daily prices are
recommended for accurate volatility estimation.
}
\examples{
data("sample_prices_daily")
data("sample_prices_weekly")
# Create a selection first
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, n = 10)

# Simple inverse volatility weighting
weights <- weight_by_risk_parity(selected, sample_prices_daily, method = "inverse_vol")

# Equal Risk Contribution for balanced exposure
weights <- weight_by_risk_parity(selected, sample_prices_daily, method = "equal_risk")

# Maximum Diversification Portfolio
weights <- weight_by_risk_parity(selected, sample_prices_daily, method = "max_div")
}
