% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{data_preparing}
\alias{data_preparing}
\title{Preparing a data set for further data processing or price index calculations}
\usage{
data_preparing(
  data,
  time = NULL,
  prices = NULL,
  quantities = NULL,
  prodID = NULL,
  retID = NULL,
  description = NULL,
  codeIN = NULL,
  codeOUT = NULL,
  grammage = NULL,
  unit = NULL,
  additional = c()
)
}
\arguments{
\item{data}{The user's data frame to be prepared. The user must indicate columns: \code{time} (as Date or character type, allowed formats are, eg.: `2020-03` or `2020-12-28`), \code{prices} and \code{quantities} (as numeric). Optionally, the user may also indicate columns: \code{prodID}, \code{codeIN}, \code{codeOUT}, \code{retID} (as numeric, factor or character), \code{description},  \code{grammage} (as numeric or character), \code{unit} (as character) and other columns specified by the \code{additional} parameter.}

\item{time}{A character name of the column which provides transaction dates.}

\item{prices}{A character name of the column which provides product prices.}

\item{quantities}{A character name of the column which provides product quantities.}

\item{prodID}{A character name of the column which provides product IDs. The \code{prodID} column should include unique product IDs used for product matching (as numeric or character). It is not obligatory to consider this column while data preparing but it is required while price index calculating (to obtain it, please see \code{\link{data_matching}}).}

\item{retID}{A character name of the column which provides outlet IDs (retailer sale points). The \code{retID} column should include unique outlet IDs used for aggregating subindices over outlets. It is not obligatory to consider this column while data preparing but it is required while final price index calculating (to obtain it, please see the \code{\link{final_index}} or \code{\link{final_index2}} function).}

\item{description}{A character name of the column which provides product descriptions. It is not obligatory to consider this column while data preparing but it is required while product selecting (please see the \code{\link{data_selecting}} function).}

\item{codeIN}{A character name of the column which provides internal product codes (from the retailer). It is not obligatory to consider this column while data preparing but it may be required while product matching (please see the \code{\link{data_matching}} function).}

\item{codeOUT}{A character name of the column which provides external product codes (e.g. GTIN or SKU). It is not obligatory to consider this column while data preparing but it may be required while product matching (please see the \code{\link{data_matching}} function).}

\item{grammage}{A character name of the numeric column which provides the grammage of products}

\item{unit}{A character name of the column which provides the unit of the grammage of products}

\item{additional}{A character vector of names of additional columns to be considered while data preparing (records with missing values are deleted).}
}
\value{
The resulting data frame is free from missing values, zero or negative prices and quantities. As a result, column \code{time} is set to be Date type (in format: `Year-Month-01`), columns \code{prices} and \code{quantities} are set to be numeric. If the column \code{description} is selected, then it is set to be character type. If columns: \code{prodID}, \code{retID}, \code{codeIN} or  \code{codeOUT} are selected, then they are set to be factor type.
}
\description{
This function returns a prepared data frame based on the user's data set. The resulting data frame is ready for further data processing (such as data selecting, matching or filtering) and it is also ready for price index calculations (if only it contains required columns).
}
\examples{
\donttest{data_preparing(milk, time="time",prices="prices",quantities="quantities")}
\donttest{data_preparing(dataCOICOP, time="time",
prices="prices",quantities="quantities",additional="coicop")}
}
