% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoFAST.R
\name{get.top.signature.dat}
\alias{get.top.signature.dat}
\title{Obtain the top signature genes and related information}
\usage{
get.top.signature.dat(df.list, ntop = 5, expr.prop.cutoff = 0.1)
}
\arguments{
\item{df.list}{a list that is obtained by the function \code{\link{find.signature.genes}}.}

\item{ntop}{an optional positive integer, specify the how many top signature genes extracted, default as 5.}

\item{expr.prop.cutoff}{an optional postive real ranging from 0 to 1,  specify cutoff of expression proportion of  features, default as 0.1.}
}
\value{
return  a `data.frame` object with four columns: `distance`,`expr.prop`, `label` and `gene`.
}
\description{
Obtain the top signature genes and related information.
}
\details{
Using this funciton, we obtain the top signature genes and organize them into a data.frame. The `row.names` are gene names.
The colname `distance` means the distance between gene (i.e., VPREB3) and cells with the specific cell type (i.e., B cell),
 which is calculated based on the coembedding of genes and cells in the coembedding space. The distance is smaller, the association between gene and the cell type is stronger. 
 The colname `expr.prop` represents the expression proportion of the gene (i.e., VPREB3) within the cell type (i.e., B cell). 
 The colname `label` means the cell types and colname `gene` denotes the gene name. 
 By the data.frame object, we know `VPREB3` is the one of the top signature gene of B cell.
}
\examples{
library(Seurat)
data(pbmc3k_subset)
pbmc3k_subset <- pdistance(pbmc3k_subset, reduction='ncfm')
df_list_rna <- find.signature.genes(pbmc3k_subset)
dat.sig <- get.top.signature.dat(df_list_rna, ntop=5)
head(dat.sig)
}
\references{
None
}
\seealso{
None
}
