% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/get_recent_personal_explanations_specific_member.R
\name{get_recent_personal_explanations_specific_member}
\alias{get_recent_personal_explanations_specific_member}
\title{Get Recent Personal Explanations by a Specific Members}
\usage{
get_recent_personal_explanations_specific_member(member_id, congress,
  myAPI_Key)
}
\arguments{
\item{member_id}{The ID of the member to retrieve; it is assigned by the Biographical Directory of the United States Congress or can be retrieved from a member list request.}

\item{congress}{110-115}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent personal explanations by a specific member in the specified Congress, and supports paginated requests using multiples of 20.
}
\description{
Lawmakers, mostly in the House but also in the Senate, can make personal explanations for missed or mistaken votes in the Congressional Record. HTTP Request: GET https://api.propublica.org/congress/v1/members/{member_id}/explanations/{congress}.json
}
\examples{
\donttest{
get_recent_personal_explanations_specific_member('S001193', 115)
}
}
