% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_recent_congressional_statements_by_term.R
\name{get_recent_congressional_statements_by_term}
\alias{get_recent_congressional_statements_by_term}
\title{Get Congressional Statements by Search Term}
\usage{
get_recent_congressional_statements_by_term(term, page = 1, myAPI_Key)
}
\arguments{
\item{term}{search term}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent results that contain the search term in the title or body of the statement and supports pagination using multiples of 20.
}
\description{
To get lists of statements published on congressional websites using a search term, use the following function. HTTP Request: GET https://api.propublica.org/congress/v1/statements/search.json?query={term}
}
\examples{
\donttest{
get_recent_congressional_statements_by_term('AHCA')
}
}
