% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbReco-package.R
\docType{package}
\name{ProbReco-package}
\alias{ProbReco}
\alias{ProbReco-package}
\title{ProbReco: Score Optimal Probabilistic Forecast Reconciliation}
\description{
Training of reconciliation weights for probabilistic forecasts to optimise total energy (or variogram) score using Stochastic Gradient Descent with automatically differentiated gradients. See Panagiotelis, Gamakumara, Athanasopoulos and Hyndman, (2020) <https://www.monash.edu/business/ebs/research/publications/ebs/wp26-2020.pdf> for a description of the methods.
}
\details{
This package carries out probabilistic forecast reconciliation via score 
optimisation using the method described by \insertCite{wp;textual}{ProbReco}.  Given incoherent (base) probabilistic forecasts formed over a 
training data set, the function \code{\link[ProbReco]{scoreopt}} finds linear 
reconciliation weights that optimise total 
score \insertCite{scores}{ProbReco} over the training 
data.  Currently the energy score and variogram score are implemented.  The 
optimisation is carried out using the Adaptive Moments (Adam) variant 
of Stochastic Gradient Descent developed 
by \insertCite{adam;textual}{ProbReco}.  Tuning parameters for this 
optimisation can be 
set using \code{\link[ProbReco]{scoreopt.control}}.  The gradients are found 
using the automatic differentiation libraries of the Stan 
project \insertCite{stan}{ProbReco}.  

A version of the function that allows for simpler inputs is provided 
by \code{\link[ProbReco]{inscoreopt}}.  Rather than using arguments that are 
lists of realisations and lists of 
functions, a matrix of data and a matrix of (point) predictions are the main 
arguments.  This function is less general 
than \code{\link[ProbReco]{scoreopt}} in two ways.  First, there are only a 
limited range of options for producing base forecasts (either from Gaussian
distributions or bootstrapping).  Second, the scores are evaluated 
using in-sample predictions rather than genuine forecasts.
}
\references{
\insertAllCited{}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/anastasiospanagiotelis/ProbReco}
  \item Report bugs at \url{https://github.com/anastasiospanagiotelis/ProbReco/issues}
}

}
\author{
\strong{Maintainer}: Anastasios Panagiotelis \email{anastasios.panagiotelis@sydney.edu.au} (\href{https://orcid.org/0000-0001-8678-7294}{ORCID})

}
\keyword{internal}
