% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_seqs.R
\name{read.seqs}
\alias{read.seqs}
\title{Reading response processes from csv files}
\usage{
read.seqs(file, style, id_var = NULL, action_var = NULL,
  time_var = NULL, step_sep = ",", ...)
}
\arguments{
\item{file}{the name of the csv file from which the response processes are to be read.}

\item{style}{the style that the response processes are stored. See 'Details'.}

\item{id_var}{a string giving the name of the variable storing the process identifier.}

\item{action_var}{a string giving the name of the variable storing action sequences.}

\item{time_var}{a string giving the name of the variable storing timestamp sequences.}

\item{step_sep}{the step separator characters. It is only used if \code{style="single"}.}

\item{...}{further arguments to be passed to \code{read.csv}.}
}
\value{
\code{read.seqs} returns an object of class \code{"\link{proc}"}.
}
\description{
Reads a csv file and creates response process data.
}
\details{
\code{read.seqs} calls \code{read.csv} to read process data stored in a csv file into \code{R}.
The csv file to be read should at least include an identifier of distinct response processes, 
and action sequences. It can also include timestamp sequences.

The response processes (action sequences and timestamp sequences) stored in csv files can 
be in one of the two styles, \code{"single"} and \code{"multiple"}. In \code{"single"} style,
each response process occupies a single line. Actions and timestamps at different steps 
are separated by \code{step_sep}. In \code{"multiple"} style, each response process occupies 
multiple lines with each step taking up one line.
}
