% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.permutedReserve.R
\name{plot.permutedReserve}
\alias{plot.permutedReserve}
\title{Plotting the output of the permutation bootstrap}
\usage{
\method{plot}{permutedReserve}(x, ...)
}
\arguments{
\item{x}{an object of the class \code{permutedReserve} -- i.e., the output
of the \code{permuteReserve()} function}

\item{...}{other graphical parameters to plot}
}
\value{
The function returns a layout for four plots. The first panel shows
a simple barplot type visualization of the estimated reserve, the estimated
ultimate and the true reserve (if available). The second panel provides
a histogram for (permuted) bootstrapped reserves with a nonparametric estimate
of the corresponding density. The third panel provides a detailed inspection
of the bootstrapped ultimates (with true ultimates if provided) and, finaly,
the last panel shows the observed diagonal vs. simulated ones.
}
\description{
The function provides a graphical visualization of the results obtained from
the permutation bootstrap (see Maciak, Mizera, and Pesta (2022) for further
details) applied to the output of one of the nonparametric functional based
estimation algorithm---PARALLAX or REACT implemented in the
\code{parallelReserve()} function or MACRAME implemented in the
\code{mcReserve()} function.
}
\examples{
## reserve estimated by MACRAME and the corresponding visualization
x <- mcReserve(CameronMutual)
plot(permuteReserve(x, B = 100))

}
\seealso{
\code{\link[=permuteReserve]{permuteReserve()}}
}
