stub.tests <- function()
{
  generate.arguments <- function(fun.name, tmp.env)
  {
    arguments <- names(formals(get(fun.name, envir = tmp.env)))
    return(paste(sapply(arguments, function (argument) {paste(argument, '= NULL')}), collapse = ', '))
  }
  
  generate.test <- function(fun.name, tmp.env)
  {
    paste('expect_that(', fun.name, '(', generate.arguments(fun.name, tmp.env), '), equals(NULL))', sep = '')
  }
  
  unlink(file.path('tests', 'autogenerated.R'))
  
  # Source each file in the `lib` directory in a temporary environment.
  lib.files <- dir('lib')
  tmp.env <- new.env()

  message(paste('Generating stub tests in ', file.path('tests', 'autogenerated.R'), ':', sep = ''))
  
  for (lib.file in lib.files)
  {
    sys.source(file.path('lib', lib.file), envir = tmp.env)

    # Create a test for each function created by those files.
    for (symbol in ls(tmp.env))
    {
      if (class(get(symbol, envir = tmp.env)) == 'function')
      {
        cat(generate.test(symbol, tmp.env),
            file = file.path('tests', 'autogenerated.R'),
            append = TRUE)
        cat('\n',
            file = file.path('tests', 'autogenerated.R'),
            append = TRUE)
        message(paste(' ', symbol, sep = ''))
      }
    }
  }
}
