% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_RENDIS.R
\name{get_data_RENDIS}
\alias{get_data_RENDIS}
\title{Retrieve data from the ReNDiS database on soil defense public works.}
\usage{
get_data_RENDIS(
  cod_reg,
  cod_prov = NULL,
  cod_mun = NULL,
  start = NULL,
  end = NULL,
  type = NULL,
  geo_ref = NULL
)
}
\arguments{
\item{cod_reg}{character. The ISTAT regional code is used to filter data based on one or more specific regions of interest. (See \code{\link{get_codes}} function)}

\item{cod_prov}{character. The ISTAT province code is used to specify one or more provinces of interest within the region(s) of interest. (See \code{\link{get_codes}} function)}

\item{cod_mun}{character. The ISTAT municipality code is used to specify one or more municipalities of interest within the region(s) of interest. (See \code{\link{get_codes}} function)}

\item{start}{character (format YYYY-mm-dd). Effective starting date of design refers to the specific phase of a public project that marks the beginning of its design process. This date can be of interest for filtering and analyzing relevant data.}

\item{end}{character (format YYYY-mm-dd). Effective ending date of design refers to the specific phase of a public project that marks the conclusion of its design process. This date can be of interest for filtering and analyzing relevant data.}

\item{type}{character. a character string on which type of intervetion data needs to be retrieved. To get information about type see \code{\link{get_type_RENDIS}} function.}

\item{geo_ref}{character. The georeference data can be specified using the \code{geo_ref} argument. If set to \code{A}, the function returns shape polygons of each municipality. If set to \code{C}, it retrieves the coordinates of the centroids of each municipality.}
}
\value{
Object of class \code{tbl_df, tbl, data.frame} showing 25 variables.
Descriptive Variables:
\itemize{
\item{CUP (\code{character})}
\item{Intervention (\code{character})}
\item{Type (\code{character})}
}

Financial Variable:
\itemize{
\item{Finance (\code{numeric})}
}

Geographical References:
\itemize{
\item{DEN_REGION (\code{character})}
\item{DEN_PROVINCE (\code{character})}
\item{DEN_MUNICIPALITY (\code{character})}
\item{COD_REGION (\code{character})}
\item{COD_PROVINCE (\code{character})}
\item{COD_MUNICIPALITY (\code{character})}
\item{geom (\code{character})}
}

Legislative process main steps:
\itemize{
\item{Feasibility Study Starting Date (\code{character})}
\item{Feasibility Study Ending Date (\code{character})}
\item{Preliminary Design Starting Date (\code{character})}
\item{Preliminary Design Ending Date (\code{character})}
\item{Definitive Design Starting Date (\code{character})}
\item{Definitive Design Ending Date (\code{character})}
\item{Executive Design Starting Date (\code{character})}
\item{Executive Design Ending Date (\code{character})}
\item{Works Execution Starting Date (\code{character})}
\item{Works Execution Ending Date (\code{character})}
\item{Conclusion Starting Date (\code{character})}
\item{Conclusion Ending Date (\code{character})}
\item{Intervention Closed (\code{character})}
\item{Operability (\code{character})}
}
}
\description{
The \code{get_data_RENDIS} function enables the retrieval of data from one or more region or type of intervention using associated codes. It allows filtering based on: municipality code, and the project's starting and/or ending dates. Additionally, it provides geospatial references.
}
\examples{
data_12 <- get_data_RENDIS("12", cod_prov = c("258", "059"), geo_ref = "C")
#Data for the Lazio region filtering for Rome and Latina provinces with point georeferences.

}
\references{
\href{http://www.rendis.isprambiente.it/rendisweb/}{ReNDiS}
}
\author{
Lorena Ricciotti
}
