% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{pval_plot}
\alias{pval_plot}
\title{Plot one-tailed p-values}
\usage{
pval_plot(yi, vi, sei, alpha_select = 0.05)
}
\arguments{
\item{yi}{A vector of point estimates to be meta-analyzed. The signs of the
estimates should be chosen such that publication bias is assumed to operate
in favor of positive estimates.}

\item{vi}{A vector of estimated variances (i.e., squared standard errors) for
the point estimates.}

\item{sei}{A vector of estimated standard errors for the point estimates.
(Only one of \code{vi} or \code{sei} needs to be specified).}

\item{alpha_select}{Alpha level at which an estimate's probability of being
favored by publication bias is assumed to change (i.e.,
the threshold at which study investigators, journal editors, etc., consider
an estimate to be significant).}
}
\description{
Plots the one-tailed p-values. The leftmost red line indicates the cutoff for
one-tailed p-values less than 0.025 (corresponding to "affirmative" studies;
i.e., those with a positive point estimate and a two-tailed p-value less than
0.05). The rightmost red line indicates one-tailed p-values greater than
0.975 (i.e., studies with a negative point estimate and a two-tailed p-value
less than 0.05). If there is a substantial point mass of p-values to the
right of the rightmost red line, this suggests that selection may be
two-tailed rather than one-tailed.
}
\examples{
# compute meta-analytic effect sizes
require(metafor)
dat <- metafor::escalc(measure = "RR", ai = tpos, bi = tneg, ci = cpos,
                       di = cneg, data = dat.bcg)

# flip signs since we think publication bias favors negative effects
dat$yi <- -dat$yi

pval_plot(yi = dat$yi, vi = dat$vi)
}
\references{
\insertRef{mathur2020}{metabias}
}
