% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{ppl_prep_data}
\alias{ppl_prep_data}
\title{Check the classes of specific columns and re-assigns as necessary.}
\usage{
ppl_prep_data(data, Subject = NULL, Item = NA,
  EventColumns = c("Subject", "TRIAL_INDEX"))
}
\arguments{
\item{data}{A data frame object created from an Eyelink Sample Report.}

\item{Subject}{An obligatory string containing the column name corresponding to the subject identifier.}

\item{Item}{An optional string containing the column name corresponding to the item identifier; by default, NA.}

\item{EventColumns}{A vector specifying the columns which will be used for creating
the Event variable; by default, Subject and TRIAL_INDEX.}
}
\value{
An object of type data table as described in \link[tibble]{tibble}.
}
\description{
\code{ppl_prep_data} checks for necessary columns and converts the class
if needed.
}
\examples{
# Load example data
data("Pupilex1")

dat <- ppl_prep_data(Pupilex1, Subject = "RECORDING_SESSION_LABEL",
                     Item = "item",
                     EventColumns = c("Subject","TRIAL_INDEX"))

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Basic_Preprocessing", package="PupilPre")

}
