% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_smoothed_data.R
\name{interpolate_data}
\alias{interpolate_data}
\title{Interpolate across the gaps in data}
\usage{
interpolate_data(data, pupil, type = c("linear", "cubic"))
}
\arguments{
\item{data}{a PupillometryR dataframe}

\item{pupil}{Column name for pupil data to be interpolated}

\item{type}{string indicating linear or cubic interpolation to be performed.}
}
\value{
interpolated pupillometry data
}
\description{
Once data is smoothed, it is important to deal with missing observations, such as blinks.
This allows simple interpolation over missing values, either linear, or cubic.
Depending on the analysis planed, this may not be a necessary option, but it is
strongly recommended for the functional analyses planned in this package.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
subject = ID,
trial = Trial,
time = Time,
condition = Type)
mean_data <- calculate_mean_pupil_size(data = Sdata,
pupil1 = RPupil, pupil2 = LPupil)
filtered_data <- filter_data(data = mean_data,
pupil = mean_pupil,
filter = 'hanning',
degree = 11)
int_data <- interpolate_data(data = filtered_data,
pupil = mean_pupil,
type = 'linear')
}
