% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALoD.R
\name{momALoD}
\alias{momALoD}
\title{Method of moments (MoM) estimation for the quantile-based asymmetric logistic distribution.}
\usage{
momALoD(y, alpha = NULL)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.  If \eqn{\alpha} is unknown, indicate NULL which is the default option. In this case, the sample skewness will be used to estimate \eqn{\alpha}. If \eqn{\alpha} is known, then the value of \eqn{\alpha} has to be specified in the function.}
}
\value{
\code{\link{momALoD}} provides the method of moments estimates of the unknown parameters of the distribution.
}
\description{
Parameter estimation in the quantile-based asymmetric logistic distribution by using method of moments are studied in Gijbels et al. (2019a).
}
\examples{
# Example
y=rnorm(100)
momALoD(y=y,alpha=0.5) # If alpha is known with alpha=0.5
momALoD(y=y) # If alpha is unknown

}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, to appear.
}
}
