% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_terraclimate}
\alias{get_terraclimate}
\title{Get TerraClimate Data for a Given Coordinate(s)}
\usage{
get_terraclimate(
  lat,
  lon,
  from = "1958-01-01",
  to = "2022-12-31",
  clim_vars = NULL,
  month_mask = NULL,
  offline = FALSE,
  data_path = "./data/"
)
}
\arguments{
\item{lat}{Vector of Latitude(s) in decimal degree format.}

\item{lon}{Vector of Longitude(s) in decimal degree format.}

\item{from}{Start date as a string in the 'YYYY-MM-DD' format.}

\item{to}{End date as a string in the 'YYYY-MM-DD' format.}

\item{clim_vars}{List of all climate variables to be imported. Valid list includes: \emph{aet, def, pet,
ppt, q, soil, srad, swe, tmax, tmin, vap, ws, vpd, and PDSI}. Default is NULL for all.}

\item{month_mask}{A list of all months of interest (e.g., planting season: \code{c(10:12,1:5)}). 
Default is NULL for all.}

\item{offline}{Extract TerraClimate data from downloaded netCDF files (default is FALSE)}

\item{data_path}{String contains the directory path where downloaded netCDF files exists (default is './data/')}
}
\value{
A list of two data.frame(s) for each pair of coordinates:
\itemize{
\item \strong{climate:} includes the climate variables (\href{https://www.climatologylab.org/terraclimate-variables.html}{reference}).
\item \strong{biovars:} includes the calculated bioclimatic variables (\href{https://www.worldclim.org/data/bioclim.html}{reference}).
}
}
\description{
\href{https://www.climatologylab.org/terraclimate.html}{TerraClimate} is a monthly climate dataset 
for global terrestrial surfaces from 1958-2021. This function enables you to extract 
\href{https://www.climatologylab.org/terraclimate-variables.html}{climate variables} from the 
\href{http://thredds.northwestknowledge.net:8080/thredds/terraclimate_aggregated.html}{hosting server} 
provided by the \href{https://hpc.uidaho.edu/}{Idaho University} for a given coordinate(s) without 
a need to download the whole raster files in the netCDF format (~100MB per variable for each year) 
and provide them in a standard data frame format ready to use in your code. It also calculates the 
\href{https://www.worldclim.org/data/bioclim.html}{bioclimatic variables} using the \code{\link{calc_biovars}} 
function derivative from the \href{https://github.com/rspatial/dismo/blob/master/R/biovars.R}{dismo R package}.

TerraClimate vs. \href{https://www.worldclim.org/data/worldclim21.html}{WorldClim}
\itemize{
\item 1958-2021 vs. 1970-2000
\item 14 vs. 7 climate variables
\item ~4 km vs. ~1 km spatial resolution
\item need to calculate vs. pre-calculated 19 bioclimatic variables
}
}
\examples{
if (interactive()) {
  # data <- get_terraclimate(36.016, 36.943, 
  #                          '1979-09-01', '2012-06-30', 
  #                          c('ppt', 'tmin', 'tmax'), c(10:12,1:5))
  data <- get_terraclimate(36.016, 36.943, '1979-09-01', '2012-06-30')

  View(data$climate[[1]])

  View(data$biovars[[1]])
}
}
\references{
Abatzoglou, J., Dobrowski, S., Parks, S. \emph{et al.} TerraClimate, a high-resolution 
            global dataset of monthly climate and climatic water balance from 1958-2015. 
            \emph{Sci Data} \strong{5}, 170191 (2018). 
            \doi{10.1038/sdata.2017.191}
}
\seealso{
\code{\link{ini_terraclimate}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
