% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boolean.R
\name{consistency}
\alias{consistency}
\title{Compute the consistency value}
\usage{
consistency(formula1, type = "->", formula2, data)
}
\arguments{
\item{formula1}{A string, list of strings or function representing a Boolean formula in disjunctive normal form}

\item{type}{either "->", "<-" or "<->", depending on the direction of the implication that is to be evaluated}

\item{formula2}{A string, list of strings or function representing a Boolean formula in disjunctive normal form}

\item{data}{A data frame where the rows represent cases and the columns the sets. Column names must be as in the formula.}
}
\value{
the consistency score of the implication described by \code{formula1}, \code{type} and \code{formula2}
}
\description{
Computes the consistency score of "formula1 -> formula2" (sufficient condition) 
or "formula1 <- formula2" (necessary condition), depending on whether \code{type}
is "->" or "<-".
If \code{type} is "<->" it computes an equivalence score of formula1 and formula2
via the formula \code{sum(min(X,Y))/(sum(max(X,Y))}
}
\details{
Compute a consistency score for an implication/necessity/sufficiency statement.


If \code{formula} is a function, it must take a \code{data.frame} and return
a vector.

If \code{formula} is a string or list of strings, the following conventions hold:
Set names must be capitalized in the formula and the data; if they are
lowercase, they are interpreted as the negation of the set.
If \code{formula} is a string, logical 'or' is expressed as a '+',
and logical 'and' as a '*'.
If \code{formula} is a list of strings, the strings are assumed to be
the dosjuncts and are concatenated with '+'.
The formula must be in disjunctive normal form, i.e. it must be a disjunction of
conjunctions of elementary or negated elementary sets. Example:
\code{A*b*C + a*B}
}
\examples{
require(QCAGUI)
data(d.urban)
consistency("MLC + FRB", "->", "CP", d.urban)

}

