% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Confidence_Interval_Beta_Distribution.R
\name{beta.meths.CI}
\alias{beta.meths.CI}
\title{Returns individual confidence intervals and simultaneous confidence intervals
based on the zero-inflated beta distribution (not bias corrected - see note below).}
\usage{
beta.meths.CI(
  predator.mat,
  prey.mat,
  cal.mat = rep(1, length(ext.fa)),
  dist.meas,
  noise = 0,
  nprey,
  R.p,
  R.ps,
  R,
  p.mat,
  alpha,
  FC = rep(1, nrow(prey.mat)),
  ext.fa
)
}
\arguments{
\item{predator.mat}{matrix containing the fatty acid signatures of the predators.}

\item{prey.mat}{prey database. A dataframe with first column a
Species label and other columns fatty acid proportions. Fatty
acid proportions are compositional.}

\item{cal.mat}{matrix of calibration coefficients of
predators. Each column corresponds to a different predator. At
least one calibration coefficient vector must be supplied.}

\item{dist.meas}{distance measure to use for estimation: 1=KL,
2=AIT or 3=CS}

\item{noise}{proportion of noise to include in the simulation.}

\item{nprey}{number of prey to sample from the the prey database
when generating pseudo-predators for the nuisance parameter
estimation.}

\item{R.p}{number of beta diet distributions to generate for the
nuisance parameters.}

\item{R.ps}{number of pseudo predators to generate when estimating
nuisance parameters.}

\item{R}{number of bootstrap replicates to use when generating
p-values for confidence interval estimation.}

\item{p.mat}{matrix of predator diet estimates for which we are
trying to find confidence intervals.}

\item{alpha}{confidence interval confidence level.}

\item{FC}{vector of prey fat content. Note that this vector is
passed to the \code{\link{gen.pseudo.seals}} which expects fat
content values for individual prey samples while
\code{\link{pseudo.seal}} and  \code{\link{p.QFASA}}
expect a species average.}

\item{ext.fa}{subset of fatty acids to be used to obtain QFASA diet
estimates.}
}
\value{
Individual confidence intervals and simultaneous confidence
    intervals based on the zero-inflated beta distribution. These
    intervals are biased and should be corrected using the output
    from \code{\link{bias.all}}. \code{ci.l.1} and \code{ci.u.1}
    contain the simultaneous confidence intervals.
}
\description{
For details see:
    Stewart, C. (2013)  Zero-Inflated Beta Distribution for Modeling the Proportions in
    Quantitative Fatty Acid Signature Analysis.
    Journal of Applied Statistics, 40(5), 985-992.
}
\details{
Note:
\itemize{
    \item These intervals are biased and should be corrected using the
          output from \code{\link{bias.all}}.
    \item \code{CI.L.1} and \code{CI.U.1} contain the simultaneous
          confidence intervals.
    \item Slow because of bisection and lots of repetition.
}
}
\examples{
#####  beta.meths.CI is deprecated.  Please use conf.meth! #####
## Fatty Acids
data(FAset)
fa.set = as.vector(unlist(FAset))

## Predators
data(predatorFAs)
tombstone.info = predatorFAs[,1:4]
predator.matrix = predatorFAs[, fa.set]
npredators = nrow(predator.matrix)

## Prey
prey.sub = preyFAs[, fa.set]
prey.sub = prey.sub / apply(prey.sub, 1, sum)
group = as.vector(preyFAs$Species)
prey.matrix.full = cbind(group,prey.sub)
prey.matrix = MEANmeth(prey.matrix.full)

## Calibration Coefficients
data(CC)
cal.vec = CC[CC$FA \%in\% fa.set, 2]
cal.mat = replicate(npredators, cal.vec)

# Note: uncomment examples to run. CRAN tests fail because execution time > 5 seconds
# set.seed(1234)
# diet.est <- p.QFASA(predator.mat = predator.matrix,
#                     prey.mat = prey.matrix,
#                     cal.mat = cal.mat,
#                     dist.meas = 2,
#                     start.val = rep(1,nrow(prey.matrix)),
#                     ext.fa = fa.set)[['Diet Estimates']]
#
# ci = beta.meths.CI(predator.mat = predator.matrix,
#                    prey.mat = prey.matrix.full,
#                    cal.mat = cal.mat,
#                    dist.meas = 2,
#                    nprey = 10,
#                    R.p = 1,
#                    R.ps = 10, #
#                    R = 1,
#                    p.mat = diet.est,
#                    alpha = 0.05,
#                    ext.fa = fa.set)

}
\references{
Stewart, C. (2013) Zero-inflated beta distribution for
    modeling the proportions in quantitative fatty acid signature
    analysis. Journal of Applied Statistics, 40(5), 985-992.
}
\keyword{internal}
