% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.cmprsk.R
\name{summary.cmprsk}
\alias{summary.cmprsk}
\title{summary for competing risks regression}
\usage{
\S3method{summary}{cmprsk}(object,\dots)
}
\arguments{
\item{object}{a crr model object from function 
\code{\link[QHScrnomo]{crr.fit}}}

\item{...}{other parameters}
}
\value{
a matrix
}
\description{
generate summary information
}
\details{
summarize a crr regression model
}
\examples{

data(prostate.dat)
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y= TRUE, surv=TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f,cencode = 0,failcode = 1)
summary(prostate.crr)


}
\author{
changhong
}
