% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bondValuation.R
\name{price.dirty2clean}
\alias{price.dirty2clean}
\title{From one price to another}
\usage{
price.dirty2clean(
  maturity,
  analysis.date = Sys.Date(),
  price,
  dirty = 1,
  coupon.rate,
  principal = 1,
  asset.type = "TES",
  freq = NULL,
  daycount = "NL/365"
)
}
\arguments{
\item{maturity}{Last day of the contract: YYYY-MM-DD.
Alternatively, it can be a numeric value that represents the duration of the contract in years.}

\item{analysis.date}{Date in which the asset is valued. By default, the
current date.}

\item{price}{Numeric value. Price of the bond to convert.}

\item{dirty}{Numeric value. Determines if the input price corresponds to the
dirty price or the clean price. For dirty price, set \code{dirty = 1}.
Otherwise, \code{dirty = 0}}

\item{coupon.rate}{Coupon rate of the asset. Can be an unique numeric
value or a vector corresponding to each coupon payment date.}

\item{principal}{Notional amount for the asset.}

\item{asset.type}{String that determines the asset type to value. See also
'Details'.}

\item{freq}{Frequency of payments of a given asset in a year. For LIBOR and
IBR the default frequency is four (quarterly payments). TES has a default
frequency of one (annual payments).}

\item{daycount}{Day count convention. See also 'Details'.}
}
\value{
The dirty price or clean price of a bond.
}
\description{
Converts bond prices from dirty to clean and viceversa.
}
\details{
\code{asset.type} makes reference to the following type of assets:
\itemize{
   \item "TES" for Colombian Treasury Bonds (default).
   \item "FixedIncome" for assets that are indexed to a fixed income with
   different frequency of payments.
   \item "IBR" for bonds and assets indexed to 3M IBR rate.
   \item "LIBOR" for bonds and assets indexed to 3M LIBOR.
     }

\code{daycount} convention accepts the following values:
\itemize{
    \item 30/360.
    \item ACT/365.
    \item ACT/360 (Default).
    \item ACT/365L.
    \item NL/365.
    \item ACT/ACT-ISDA
    \item ACT/ACT-AFB
}
}
\examples{
price.dirty2clean(maturity = "2026-01-03", analysis.date = "2023-01-02",
                  price = 1, dirty = 1, coupon.rate = 0.04, principal = 1)
price.dirty2clean(maturity = "2026-01-03", analysis.date = "2023-01-02",
                  price = 0.9601096, dirty = 0, coupon.rate = 0.04, principal = 1)
}
