% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allequal.R
\name{outer_allequal}
\alias{outer_allequal}
\title{Test if Two \link[base]{double} Vectors are Element-Wise (Nearly) Equal}
\usage{
outer_allequal(target, current, tolerance = sqrt(.Machine$double.eps), ...)
}
\arguments{
\item{target}{length-\eqn{n_t} \link[base]{double} \link[base]{vector},
the target value(s), missing value not allowed}

\item{current}{length-\eqn{n_c} \link[base]{double} \link[base]{vector},
the value(s) to be compared with \code{target}, missing value not allowed}

\item{tolerance}{positive \link[base]{double} scalar, default \code{sqrt(.Machine$double.eps)}}

\item{...}{potential parameters, currently not in use}
}
\value{
Function \link{outer_allequal} returns an \eqn{n_c\times n_t} \link[base]{logical} \link[base]{matrix}
indicating whether the length-\eqn{n_c} \link[base]{vector} \code{current}
is element-wise near-equal to
the length-\eqn{n_t} \link[base]{vector} \code{target}
within the pre-specified \code{tolerance}.
}
\description{
Test if two \link[base]{double} \link[base]{vector}s are element-wise (nearly) equal.
}
\details{
Function \link{outer_allequal} is different from \link[base]{all.equal.numeric}, such that
\itemize{
\item{only compares between \link[base]{double}, not \link[base]{complex}, values}
\item{element-wise comparison is performed}
\item{a \link[base]{logical} scalar is always returned for each element-wise comparison.}
}
}
\examples{
x = c(.3, 1-.7, 0, .Machine$double.eps)
outer_allequal(current = x, target = c(.3, 0))

}
\seealso{
\link[base]{outer}
}
\keyword{internal}
