% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tqDist.r
\name{TQDist}
\alias{TQDist}
\alias{TQAE}
\alias{ManyToManyQuartetAgreement}
\alias{SingleTreeQuartetAgreement}
\title{tqDist wrapper}
\usage{
TQDist(treeList)

TQAE(treeList)

ManyToManyQuartetAgreement(treeList)

SingleTreeQuartetAgreement(treeList, comparison)
}
\arguments{
\item{treeList}{List of phylogenetic trees, of class \code{list} or
\code{\link[ape:read.tree]{phylo}}.
All trees must be bifurcating.}

\item{comparison}{A tree of class \code{\link[ape:read.tree]{phylo}} against which to compare the trees
in \code{treeList}.}
}
\value{
\code{TQDist} returns the quartet distance between each pair of trees.

\code{TQAE} returns the number of resolved quartets in agreement between
each pair of trees (A in Brodal \emph{et al}. 2013) and the number of quartets
that are unresolved in both trees (E in Brodal \emph{et al}. 2013).

\code{ManyToManyQuartetAgreement} returns a three-dimensional array listing,
for each pair of trees in turn, the number of quartets in each category.

\code{SingleTreeQuartetAgreement} returns a two-dimensional array listing,
for tree in \code{treeList}, the total number of quartets and the
number of quartets in each category.
The \code{comparison} tree is treated as \code{tree2}.
}
\description{
Convenience function that takes a list of trees, writes them to the text file
expected by the C implementation of tqDist (Sand \emph{et al.} 2014).
tqDist is then called, and the temporary file is deleted when analysis is complete.
}
\details{
Quartets can be resolved in one of five ways, which
Brodal \emph{et al}. (2013) and Holt \emph{et al}. (2014) distinguish using the letters
A--E, and Estabrook (1985) refers to as:
\itemize{
\item A: \emph{s} = resolved the \strong{s}ame in both trees;
\item B: \emph{d} = resolved \strong{d}ifferently in both trees;
\item C: \emph{r1} = \strong{r}esolved only in tree \strong{1};
\item D: \emph{r2} = \strong{r}esolved only in tree \strong{2} (the comparison tree);
\item E: \emph{u} = \strong{u}nresolved in both trees.
}
}
\section{Functions}{
\itemize{
\item \code{TQAE}: Number of agreeing quartets that are resolved / unresolved.

\item \code{ManyToManyQuartetAgreement}: Agreement of each quartet, comparing each pair of trees
in a list.

\item \code{SingleTreeQuartetAgreement}: Agreement of each quartet in trees in a list with the
quartets in a comparison tree.
}}

\references{
\insertRef{Brodal2013}{Quartet}

\insertRef{Estabrook1985}{Quartet}

\insertRef{Holt2014}{Quartet}

\insertRef{Sand2014}{Quartet}
}
\author{
Martin R. Smith
}
