% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Untoggle.R
\name{Untoggle}
\alias{Untoggle}
\title{Converts a categorical variable into several separate binary variables}
\usage{
Untoggle(categrv, name = NULL)
}
\arguments{
\item{categrv}{A vector (factor) of categorical character strings
(integers).}

\item{name}{A character string specifying a name of a prefix to be appended
the categories when generating dummy variables. If \code{NULL}, \code{v__} is
used as a prefix.}
}
\value{
A matrix containing the generated dummy variables.
}
\description{
This function converts a vector (factor) of categorical character strings
(integers) into several separate vectors of binary indicators to enable
back-compatibility with versions of \pkg{R2MLwiN} prior to 0.8-0.
}
\examples{
\dontrun{
library(R2MLwiN)
# NOTE: Assumes MLwiN path is C:/Program Files (x86)/MLwiN v2.30/
# ...so please change relevant line if different
# if using R2MLwiN via WINE, the path may look like
# options(MLwiN_path='/home/USERNAME/.wine/drive_c/Program Files (x86)/MLwiN v2.30/')

# Example: tutorial
data(tutorial)
names(tutorial)
tutorial = cbind(tutorial, Untoggle(tutorial$school, 'school'))
names(tutorial)
}
}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2015) Centre for Multilevel Modelling, University of Bristol.
}

