% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Links.R
\name{links_Info}
\alias{links_Info}
\title{Used to return the page title for a given Bitlink.}
\usage{
links_Info(hashIN = NULL, shortUrl = NULL, expand_user = "true",
  showRequestURL = FALSE)
}
\arguments{
\item{hashIN}{- refers to one bitly hashes, (e.g.:  2bYgqR or a-custom-name). Required}

\item{shortUrl}{- refers to one Bitlinks e.g.: http://bit.ly/1RmnUT or http://j.mp/1RmnUT. Optional.}

\item{expand_user}{- optional true|false (default) - include extra user info in response.}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug purposes.}
}
\value{
short_url - this is an echo back of the shortUrl request parameter.

hash - this is an echo back of the hash request parameter.

user_hash - the corresponding bitly user identifier.

global_hash - the corresponding bitly aggregate identifier.

error - indicates there was an error retrieving data for a given shortUrl or hash. An
example error is "NOT_FOUND".

title - the HTML page title for the destination page (when available).

created_by - the bitly username that originally shortened this link, if the
link is public. Otherwise, null.

created_at - the epoch timestamp when this Bitlink was created.
}
\description{
Used to return the page title for a given Bitlink.
}
\note{
Either shortUrl or hash must be given as a parameter (or both).

The maximum number of shortUrl and hash parameters is 15.
}
\examples{
rbitlyApi("0906523ec6a8c78b33f9310e84e7a5c81e500909")
links_Info(shortUrl = "http://bit.ly/DPetrov")
links_Info(hash = "DPetrov", showRequestURL = TRUE)
links_Info(hash = "DPetrov", expand_user = "true")

## hash is the one which is only returned. Dont use
links_Info(shortUrl = "on.natgeo.com/1bEVhwE", hash = "DPetrov")

## manyHashes <- list("DPetrov", "1QU8CFm", "1R1LPSE", "1LNqqva")
## for (u in 1:length(manyHashes)) {
##   print(links_Info(hashIN = manyHashes[[u]], showRequestURL = TRUE))
## }
}
\seealso{
See \url{http://dev.bitly.com/links.html#v3_info}
}

