% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fusion.R
\name{Fusion}
\alias{Fusion}
\title{Validation of estimates of conditional average treatment effects in objects of class \code{TEstimator} and \code{SEstimator}.}
\value{
an R6 object
}
\description{
Validation of estimates of conditional average treatment effects in objects of class \code{TEstimator} and \code{SEstimator}.

Validation of estimates of conditional average treatment effects in objects of class \code{TEstimator} and \code{SEstimator}.
}
\examples{
\donttest{
source.data <- RCTrep::source.data
target.data <- RCTrep::target.data

vars_name <- list(outcome_predictors = c("x1","x2","x3","x4","x5","x6"),
                  treatment_name = c('z'),
                  outcome_name = c('y')
)
selection_predictors <- c("x2","x6")

source.obj <- TEstimator_wrapper(
 Estimator = "G_computation",
 data = source.data,
 vars_name = vars_name,
 outcome_method = "glm",
 outcome_form=y ~ x1 + x2 + x3 + z + z:x1 + z:x2 +z:x3+ z:x6,
 name = "RWD",
 data.public = FALSE
)

target.obj <- TEstimator_wrapper(
 Estimator = "Crude",
 data = target.data,
 vars_name = vars_name,
 name = "RCT",
 data.public = FALSE,
 isTrial = TRUE
)

strata <- c("x1","x4")
source.rep.obj <- SEstimator_wrapper(Estimator = "Exact",
                                     target.obj = target.obj,
                                     source.obj = source.obj,
                                     selection_predictors =
                                     selection_predictors)
source.rep.obj$EstimateRep(stratification = strata, stratification_joint = TRUE)

fusion <- Fusion$new(target.obj,
                     source.obj,
                     source.rep.obj)
fusion$plot()
fusion$evaluate()
}

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Fusion-new}{\code{Fusion$new()}}
\item \href{#method-Fusion-plot}{\code{Fusion$plot()}}
\item \href{#method-Fusion-print}{\code{Fusion$print()}}
\item \href{#method-Fusion-evaluate}{\code{Fusion$evaluate()}}
\item \href{#method-Fusion-clone}{\code{Fusion$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fusion-new"></a>}}
\if{latex}{\out{\hypertarget{method-Fusion-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fusion$new(..., stratification = NULL, stratification_joint = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{objects of class \code{TEstimator} and \code{SEstimator}.}

\item{\code{stratification}}{a character vector specifying variables. The variables are used to select subgroups individually or in combination depending on \code{stratification_joint}. Default value is \code{NULL}.}

\item{\code{stratification_joint}}{a logical indicating if subgroups are selected based on levels of individual variable in \code{stratification} or levels of combined variables in \code{stratifiation}. Default value is NULL.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fusion-plot"></a>}}
\if{latex}{\out{\hypertarget{method-Fusion-plot}{}}}
\subsection{Method \code{plot()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fusion$plot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fusion-print"></a>}}
\if{latex}{\out{\hypertarget{method-Fusion-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fusion$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fusion-evaluate"></a>}}
\if{latex}{\out{\hypertarget{method-Fusion-evaluate}{}}}
\subsection{Method \code{evaluate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fusion$evaluate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fusion-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Fusion-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fusion$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
