% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\title{Geocode a Czech Address}
\format{\code{sf} data frame with 3 variables + geometry

  \describe{ \item{target}{the address searched (address input)}
  \item{typ}{type of record matched by API} \item{address}{address as
  recorded by RÚIAN}  \item{geometry}{hidden column with spatial point data}
  }}
\usage{
geocode(address, crs = 4326)
}
\arguments{
\item{address}{point to be geocoded, as character (vector)}

\item{crs}{coordinate reference system of output; default = WGS84}
}
\description{
This function connects to Czech State Administration of Land Surveying and
Cadastre (\url{https://www.cuzk.cz/en}) API to geocode an address. As
consequence it is implemented only for Czech addresses.
}
\details{
Input of the function are an address to geocode (or a vector of addresses)
and expected Coordinate Reference System of output (default is WGS84 =
EPSG:4326, but in some use cases inž. Křovák = EPSG:5514 may be more
relevant).

Output is a \code{sf} data frame of spatial points.

Depending on the outcome of matching the address to RÚIAN data there is a
number of possible outcomes:

\itemize{
   \item{All items were matched exactly: the returned \code{sf} data
   frame has the same number of rows as there were elements in vector to
   be geocoded. The field \emph{target} will have zero duplicates.}
   \item{Some items had multiple matches: the returned \code{sf} data
   frame has more rows than the there were elements in vector to be geocoded.
   In the field \emph{target} will be duplicate values. Note that the RÚIAN API
   limits multiple matches to 10.}
   \item{Some (but not all) items had no match in RUIAN data: the returned
   \code{sf} data frame will have fewer rows than the vector
   to be geocoded elements. Some values will be missing from field \emph{target}}.
   \item{No items were matched at all: the function returns NA.
}}

Usage of the ČÚZK API is governed by ČÚZK Terms & Conditions -
\url{https://geoportal.cuzk.cz/Dokumenty/Podminky.pdf}.
}
\examples{
asdf <- geocode("Pod sídlištěm 9") # physical address of ČÚZK

}
