% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds.interval.estimate.R
\name{rds.interval.estimate}
\alias{rds.interval.estimate}
\title{An object of class rds.interval.estimate}
\usage{
rds.interval.estimate(estimate, outcome.variable, weight.type, uncertainty,
  weights, N = NULL, conf.level = 0.95, csubset = "")
}
\arguments{
\item{estimate}{The numerical point estimate of proportion of the
\code{trait.variable}.}

\item{outcome.variable}{A string giving the name of the variable in the
\code{rds.data} that contains a categorical variable to be analyzed.}

\item{weight.type}{A string giving the type of estimator to use. The options
are \code{"Gile's SS"}, \code{"RDS-I"}, \code{"RDS-II"}, \code{"RDS-I
(DS)"}, and \code{"Arithemic Mean"}. If \code{NULL} it defaults to
\code{"Gile's SS"}.}

\item{uncertainty}{A string giving the type of uncertainty estimator to use.
The options are \code{"SRS"}, \code{"Gile"} and \code{"Salganik"}. This is
usually determined by \code{weight.type} to be consistent with the
estimator's origins. The estimators RDS-I, RDS-I (DS), and RDS-II default to
\code{"Salganik"}, "Arithmetic Mean" defaults to \code{"SRS"} and "Gile's
SS" defaults to the \code{"Gile"} bootstrap.}

\item{weights}{A numerical vector of sampling weights for the sample, in
order of the sample.  They should be inversely proportional to the
first-order inclusion probabilites, although this is not assessed or
inforced.}

\item{N}{An estimate of the number of members of the population being
sampled. If \code{NULL} it is read as the \code{pop.size.mid} attribute of
the \code{rds.data} frame. If that is missing it defaults to 1000.}

\item{conf.level}{The confidence level for the confidence intervals. The
default is 0.95 for 95\%.}

\item{csubset}{A character string representing text to add to the output label. Typically
this will be the expression used it define the subset of the data used  for the estimate.}
}
\value{
An object of class \code{rds.interval.estimate} is returned. This is
a list with components \itemize{ \item\code{estimate}: The numerical point
estimate of proportion of the \code{trait.variable}.  \item\code{interval}:
A matrix with six columns and one row per category of \code{trait.variable}:
\itemize{ \item\code{point estimate}: The HT estimate of the population
mean.  \item\code{95\% Lower Bound}: Lower 95\% confidence bound.
\item\code{95\% Upper Bound}: Upper 95\% confidence bound.  \item\code{Design
Effect}: The design effect of the RDS.  \item\code{s.e.}: Standard error.
\item\code{n}: Count of the number of sample values with that value of the
trait.  } }
}
\description{
This function creates an object of class \code{rds.interval.estimate}.
}
\examples{

data(faux)
RDS.I.estimates(rds.data=faux,outcome.variable='X',smoothed=TRUE)

}
\references{
Gile, Krista J., Handcock, Mark S., 2010,
\emph{Respondent-driven Sampling: An Assessment of Current Methodology}.
Sociological Methodology 40, 285-327.

Salganik, M., Heckathorn, D. D., 2004. \emph{Sampling and estimation in
hidden populations using respondent-driven sampling}. Sociological
Methodology 34, 193-239.

Volz, E., Heckathorn, D., 2008. \emph{Probability based estimation theory
for Respondent Driven Sampling}. The Journal of Official Statistics 24 (1),
79-97.
}
\author{
Mark S. Handcock
\itemize{ 
		\item{RDS.II.estimates}{\code{\link{RDS.II.estimates}}}
		\item{RDS.SS.estimates}{\code{\link{RDS.SS.estimates}}}
}
}
\keyword{manip}
\keyword{survey}
