% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.utilities.R
\name{ult}
\alias{ult}
\title{Extract or replace the *ult*imate (last) element of a vector or a list, or an element counting from the end.}
\usage{
ult(x, i = 1L)
}
\arguments{
\item{x}{a vector or a list.}

\item{i}{index from the end of the list to extract or replace (where 1 is the last element, 2 is the penultimate element, etc.).}
}
\value{
An element of `x`.
}
\description{
Extract or replace the *ult*imate (last) element of a vector or a list, or an element counting from the end.
}
\examples{
x <- 1:5
(last <- ult(x))
(penultimate <- ult(x, 2)) # 2nd last.

\dontshow{
stopifnot(last==5)
stopifnot(penultimate==4)
}

}
