/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique;

import javalain.algorithmegenetique.Gene;

public class GeneComplexe
extends Gene
implements Cloneable {
    private Gene[] tabGene;
    private int nbGene;

    public GeneComplexe(int taille) {
        this.nbGene = taille;
        this.tabGene = new Gene[taille];
    }

    public void addGene(Gene ge) {
        int i;
        for (i = 0; i < this.nbGene && this.tabGene[i] != null; ++i) {
        }
        if (i == this.nbGene) {
            throw new IndexOutOfBoundsException("GeneComplexe, addGene (Gene ge) : impossible d'ajouter un Gene, le GeneComplexe est plein.");
        }
        this.tabGene[i] = ge;
    }

    public Gene getGene(int i) {
        try {
            return this.tabGene[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("GeneComplexe, getGene (int i) : indice 'i' hors des limites.");
        }
    }

    public int size() {
        return this.nbGene;
    }

    public GeneComplexe[] croisement(GeneComplexe g) {
        int i;
        GeneComplexe g1;
        GeneComplexe g0;
        try {
            g0 = (GeneComplexe)this.clone();
            g1 = (GeneComplexe)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        g0.tabGene = new Gene[this.nbGene];
        g1.tabGene = new Gene[this.nbGene];
        int point = (int)(Math.random() * (double)(this.nbGene - 1)) + 1;
        for (i = 0; i < point; ++i) {
            g0.tabGene[i] = this.tabGene[i].copier();
            g1.tabGene[i] = g.tabGene[i].copier();
        }
        for (i = point; i < this.nbGene; ++i) {
            g0.tabGene[i] = g.tabGene[i].copier();
            g1.tabGene[i] = this.tabGene[i].copier();
        }
        GeneComplexe[] gc = new GeneComplexe[]{g0, g1};
        return gc;
    }

    public Gene melanger(Gene g) {
        try {
            GeneComplexe gc = (GeneComplexe)this.clone();
            gc.tabGene = new Gene[this.nbGene];
            GeneComplexe ge = (GeneComplexe)g;
            for (int i = 0; i < this.nbGene; ++i) {
                gc.tabGene[i] = this.tabGene[i].melanger(ge.tabGene[i]);
            }
            return gc;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void mutation() {
        this.tabGene[(int)(Math.random() * (double)this.nbGene)].mutation();
    }

    public Gene copier() {
        try {
            GeneComplexe gc = (GeneComplexe)this.clone();
            gc.tabGene = new Gene[this.nbGene];
            for (int i = 0; i < this.nbGene; ++i) {
                gc.tabGene[i] = this.tabGene[i].copier();
            }
            return gc;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Gene creer() {
        try {
            GeneComplexe gc = (GeneComplexe)this.clone();
            gc.tabGene = new Gene[this.nbGene];
            for (int i = 0; i < this.nbGene; ++i) {
                gc.tabGene[i] = this.tabGene[i].creer();
            }
            return gc;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Gene creer(Gene g) {
        try {
            GeneComplexe gc = (GeneComplexe)this.clone();
            gc.tabGene = new Gene[this.nbGene];
            GeneComplexe ge = (GeneComplexe)g;
            for (int i = 0; i < this.nbGene; ++i) {
                gc.tabGene[i] = this.tabGene[i].creer(ge.tabGene[i]);
            }
            return gc;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean estEgalA(Gene g) {
        if (g instanceof GeneComplexe) {
            GeneComplexe gc = (GeneComplexe)g;
            if (this.nbGene == gc.nbGene) {
                for (int i = 0; i < this.nbGene; ++i) {
                    if (this.tabGene[i].estEgalA(gc.tabGene[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean estPlusGeneralQue(Gene g) {
        if (g instanceof GeneComplexe) {
            GeneComplexe gc = (GeneComplexe)g;
            if (this.nbGene == gc.nbGene) {
                for (int i = 0; i < this.nbGene; ++i) {
                    if (this.tabGene[i].estPlusGeneralQue(gc.tabGene[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public StringBuilder afficher() {
        int taille = this.nbGene - 1;
        StringBuilder sb = new StringBuilder("<");
        for (int i = 0; i < taille; ++i) {
            sb.append((CharSequence)this.tabGene[i].afficher());
            sb.append(" ");
        }
        sb.append((CharSequence)this.tabGene[taille].afficher());
        sb.append(">");
        return sb;
    }
}

