/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique.ihm.controle;

import java.awt.Color;
import javalain.algorithmegenetique.ihm.ControleAlgoG;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import util.GuiUtils;

public final class TexteFrontiere
extends JTextField
implements CaretListener {
    private ControleAlgoG ctrlAG;
    private boolean erreur;
    private double valeur;

    public TexteFrontiere(ControleAlgoG c) {
        super(5);
        this.addCaretListener(this);
        this.ctrlAG = c;
        this.erreur = false;
        this.valeur = Double.POSITIVE_INFINITY;
    }

    public void setValeur(double d) {
        if (this.valeur != d) {
            this.setText(GuiUtils.DECIMAL.format(d));
            this.valeur = d;
        }
    }

    public void caretUpdate(CaretEvent ce) {
        this.invokeLater();
    }

    private void invokeLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                block3: {
                    try {
                        double d = Double.parseDouble(TexteFrontiere.this.getText());
                        if (d < 0.0) {
                            throw new NumberFormatException();
                        }
                        TexteFrontiere.this.valeur = d;
                        TexteFrontiere.this.ctrlAG.getEvolution().getPopulation().getParametreAG().setSigmaShare(d);
                        TexteFrontiere.this.setBackground(Color.white);
                        TexteFrontiere.this.erreur = false;
                    }
                    catch (NumberFormatException nfe) {
                        if (TexteFrontiere.this.erreur) break block3;
                        JOptionPane.showMessageDialog(TexteFrontiere.this.ctrlAG, "<html>Sigma<sub>share</sub><br/>-----<br/>Vous devez entrer un nombre r\u00e9el positif<br>Exemple : 3.14</html>", "Message", 2);
                        TexteFrontiere.this.setBackground(GuiUtils.BLEU_ERREUR);
                        TexteFrontiere.this.erreur = true;
                    }
                }
            }
        });
    }
}

