/*
 * Decompiled with CFR 0.152.
 */
package javalain.math.fonction.simpleobjectif;

import java.util.Comparator;
import javalain.ea.SolutionEA;
import javalain.ea.operator.comparator.ObjectiveComparator;
import javalain.math.Calcul;
import javalain.math.fonction.Fct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Rosenbrock
extends Fct {
    public Rosenbrock() {
        this(10);
    }

    public Rosenbrock(int d) {
        this.nomFct = "Rosenbrock (Banana function)";
        this.nbVariable = d;
        this.nbFctObjectif = 1;
        this.lowerLimit = new double[this.nbVariable];
        this.upperLimit = new double[this.nbVariable];
        for (int i = 0; i < this.nbVariable; ++i) {
            this.lowerLimit[i] = -2.048;
            this.upperLimit[i] = 2.048;
        }
    }

    @Override
    public double[] compute(double[] x) {
        ++this.nbEvaluation;
        double[] fct = new double[this.nbFctObjectif];
        fct[0] = 0.0;
        for (int i = 0; i < this.nbVariable - 1; ++i) {
            fct[0] = fct[0] + (Calcul.pow2(1.0 - x[i]) + 100.0 * Calcul.pow2(x[i + 1] - x[i] * x[i]));
        }
        return fct;
    }

    @Override
    public double[][] getFront() {
        if (this.front == null) {
            this.front = new double[1][this.nbVariable];
            for (int i = 0; i < this.nbVariable; ++i) {
                this.front[0][i] = 1.0;
            }
        }
        return this.front;
    }

    @Override
    public Comparator<SolutionEA> comparator() {
        return new ObjectiveComparator(0);
    }
}

