/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.BinomialDist;
import umontreal.iro.lecuyer.randvar.BinomialGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class BinomialConvolutionGen
extends BinomialGen {
    private int n;
    private double p;

    public BinomialConvolutionGen(RandomStream randomStream, BinomialDist binomialDist) {
        super(randomStream, binomialDist);
        this.n = binomialDist.getN();
        this.p = binomialDist.getP();
    }

    public int nextInt() {
        int n = 0;
        for (int i = 0; i < this.n; ++i) {
            double d = this.stream.nextDouble();
            if (!(d <= this.p)) continue;
            ++n;
        }
        return n;
    }

    public static int nextInt(RandomStream randomStream, int n, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p must be in [0,1]");
        }
        return BinomialConvolutionGen.convolution(randomStream, n, d);
    }

    private static int convolution(RandomStream randomStream, int n, double d) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d2 = randomStream.nextDouble();
            if (!(d2 <= d)) continue;
            ++n2;
        }
        return n2;
    }
}

