\name{convertToPerVarScores}
\alias{convertToPerVarScores}
\title{Utility function to that converts RESET scores to/from per-variable scores}
\description{
Utility function that converts the scores generated by \link{reset} or \link{resetViaPCA} to or from per-variable scores.
This has the same effect as the \code{per.var} argument to \link{reset} or \link{resetViaPCA}. Conversion to per-variable scores will divide each overall score and each sample-level score by the scaled size of the associated variable set. The variable set sizes are scaled by dividing by the mean size among all tested sets (this will result in scores not changing in magnitude for sets of mean size). Conversion from per-variable scores will instead multiply scored by the scaled variable set size.
}
\usage{
    convertToPerVarScores(reset.out, var.sets, to.per.var=TRUE)
}
\arguments{
\item{reset.out}{The list returned from a call to \link{reset} or \link{resetViaPCA}.}
\item{var.sets}{List of variable sets where each element in the list corresponds to a set and the list element is a vector variable names. List names are variable set names. This must the same variable set structure used to create the \code{reset.out} input via \link{reset}.}
\item{to.per.var}{If true, the scores are converted to a per-variable format by dividing each score by the size of the associated variable set size.
  If false, scores are converted from a per-variable format by multiplying by the associated variable set size.}
}
\value{
Version of the input list where scores have been appropriately converted to or from a per-variable format.
}
\seealso{\code{\link{reset}},\code{\link{resetViaPCA}}}
\keyword{file}
\examples{
 # Create a collection of 3 overlapping variable sets of different sizes
 var.sets = list(set1=1:10, 
                  set2=1:20,
                  set3=1:30)

  # Simulate a 100-by-100 matrix of random Poisson data
  X = matrix(rpois(10000, lambda=1), nrow=100)

  # Inflate first 10 rows for first 10 variables, i.e., the first
  # 10 samples should have elevated scores for the first variable set
  X[1:10,1:10] = rpois(100, lambda=5)

  # Execute RESET using non-randomized basis computation
  reset.out = reset(X, var.sets=var.sets, k=2, random.threshold=20)
  
  # Display the overall scores
  reset.out$v
  
  # Convert to per-variable scores
  reset.out.2 = convertToPerVarScores(reset.out=reset.out, var.sets=var.sets, to.per.var=TRUE)
  
  # Display the overall scores in per-variable format
  reset.out.2$v
  
  # Convert from per-variable scores
  reset.out.3 = convertToPerVarScores(reset.out=reset.out.2, var.sets=var.sets, to.per.var=FALSE)
  
  # Display the overall scores
  reset.out.3$v
}
