% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3_rendoivreg.R
\name{predict.rendo.ivreg}
\alias{predict.rendo.ivreg}
\title{Predict method for fitted Regression Models with Internal Instrumental Variables}
\usage{
\method{predict}{rendo.ivreg}(object, newdata, ...)
}
\arguments{
\item{object}{Object of class inheriting from "rendo.ivreg"}

\item{newdata}{An optional data frame without any instrumental variables in which to look for variables with which to predict.
If omitted, the fitted values are returned.}

\item{...}{ignored, for consistency with the generic function.}
}
\value{
\code{predict.rendo.ivreg} produces a vector of predictions
}
\description{
Predicted values based on model objects fitted using the instrumental variables regression fitted
with IVs generated from the data.
}
\examples{
data("dataHetIV")

het <- hetErrorsIV(y~X1+X2+P|P|IIV(X1, X2),
                   data = dataHetIV)

# returns the fitted values
predict(het)

# using the data used for fitting also for predicting,
# correctly results in fitted values
all.equal(predict(het, dataHetIV), fitted(het)) # TRUE

}
\seealso{
The model fitting functions \code{\link[REndo:hetErrorsIV]{hetErrorsIV}},
\code{\link[REndo:higherMomentsIV]{higherMomentsIV}}.
}
