% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFc.R
\name{Availabe data}
\alias{Availabe data}
\title{Availabe data}
\description{
The default instance of FetchClimate at <http://fetchclimate2.cloudapp.net/> provides the following data
}
\details{
\strong{Environmental variables:}\cr
"abshum" : Absolute air humidity (g/m^3)\cr
"airt" : Air temperature near surface (Degrees C)\cr
"airt_land": Air temperature near surface. Land only areas (Degrees C)\cr
"airt_ocean" : Air temperature near surface. Ocean only areas (Degrees C)\cr
"depth_ocean" : Depth below sea level. Ocean only areas (meters)\cr
"dtr" : Diurnal air temperature rate (Degrees C)\cr
"elev" : Elevation above sea level (meters)\cr
"elev_land" : Elevation above sea level. Land only a areas (meters)\cr
"frs" : Frost days frequency (days/month)\cr
"pet": Potential evapotranspiration (mm/month)\cr
"prate" : Precipitation rate ()\cr
"relhum" : Relative humidity (percentage)\cr
"relhum_land" : Relative humidity. Land only area (percentage)\cr
"soilmoist" : Soil moisture (mm/m)\cr
"sunp" : Sunshine fraction (Percent of maximum possible sunshine)\cr
"wet" : Wet days frequency (days/month)\cr
"windspeed" : Wind speed at 10m (m/s)\cr
"wvp" : Water vapour pressure (hPa)\cr
"wvsp" : Water vapour saturation pressure (hPa)\cr

\strong{DataSets [supported variables]:}\cr
"CESM1-BGC airt" [airt]\cr
"CESM1-BGC prate" [prate]\cr
"CpcSoilMoisture" [soilmoist]\cr
"CRU CL 2.0" [airt, airt_land, dtr, frs, prate, relhum, relhum_land, sunp, wet, windspeed]\cr
"ETOPO1" [elev]\cr
"FC1 Variables" [airt_land, airt_ocean, depth_ocean, relhum_land]\cr
"GTOPO30" [elev, elev_land]\cr
"Malmstrom PET" [pet]\cr
"NCEP/NCAR Reanalysis 1 (Gauss T62)" [prate]\cr
"NCEP/NCAR Reanalysis 1 (regular grid)" [airt]\cr
"WagnerWVSP" [abshum, wvp, wvsp]\cr
"WorldClim 1.4" [airt, airt_land, prate]\cr

Note that availavle variables as well as datasets are subject to change in time
The list above describes the most recent configuration
However specifing timestamp parameter other than "Now" may lead to different set of available data
Verify the actual list using `fcVariables()` and `fcDataSets()` functions
}

