/*
 * Decompiled with CFR 0.152.
 */
package freak.core.view.swingsupport;

import java.io.Serializable;

public class SlidingWindow
implements Serializable {
    private Object[] store = new Object[0];
    private int simViewStart = 0;
    private int simViewEnd = -1;
    private int swingViewStart = 0;
    private int swingViewEnd = -1;

    public void add(Object data) {
        if (this.simViewEnd + 1 == this.store.length) {
            this.newArray();
        }
        ++this.simViewEnd;
        this.store[this.simViewEnd] = data;
    }

    public void removeFirst() {
        ++this.simViewStart;
    }

    public void clear() {
        this.simViewStart = this.simViewEnd + 1;
    }

    public Object get(int i) {
        return this.store[this.simViewStart + i];
    }

    public int size() {
        return this.simViewEnd - this.simViewStart + 1;
    }

    public void synchronizeViews() {
        this.swingViewStart = this.simViewStart;
        this.swingViewEnd = this.simViewEnd;
    }

    public Object getInSwingView(int i) {
        return this.store[this.simViewStart + i];
    }

    public int sizeInSwingView() {
        return this.swingViewEnd - this.swingViewStart + 1;
    }

    private void newArray() {
        int obsoleteFromStart = this.swingViewStart;
        int requiredSize = this.simViewEnd - obsoleteFromStart + 1;
        Object[] newStore = new Object[requiredSize * 2 + 1];
        System.arraycopy(this.store, this.swingViewStart, newStore, 0, requiredSize);
        this.store = newStore;
        this.swingViewStart -= obsoleteFromStart;
        this.swingViewEnd -= obsoleteFromStart;
        this.simViewStart -= obsoleteFromStart;
        this.simViewEnd -= obsoleteFromStart;
    }
}

