/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.control.Batch;
import freak.core.control.GenerationIndex;
import freak.core.control.Schedule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class BatchTableCellRenderer
extends DefaultTableCellRenderer {
    private Schedule schedule;
    private GenerationIndex time;
    private static final Color COLOR_FINISHED = new Color(255, 200, 200);
    private static final Color COLOR_RUNNING = new Color(255, 255, 200);
    private static final Color COLOR_COMINGUP = new Color(200, 255, 200);

    public BatchTableCellRenderer(Schedule schedule) {
        this.schedule = schedule;
        this.time = schedule.getCurrentTimeIndex();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            this.setFont(new Font("Dialog", 1, 12));
        } else {
            this.setFont(new Font("Dialog", 0, 12));
        }
        this.setBorder(noFocusBorder);
        Batch currentBatch = this.schedule.getBatchList().get(row);
        if (currentBatch.isFinished()) {
            this.setBackground(COLOR_FINISHED);
        } else if (currentBatch.isStarted()) {
            this.setBackground(COLOR_RUNNING);
        } else {
            this.setBackground(COLOR_COMINGUP);
        }
        if (column == 4) {
            this.setFont(new Font("Dialog", 1, 12));
        }
        return this;
    }
}

