/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.scheduleeditor;

import freak.core.control.GenerationIndex;
import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.FitnessTransformer;
import freak.core.graph.FreakGraphModel;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Configuration;
import freak.core.modulesupport.Module;
import freak.gui.PropertyDialog;
import freak.gui.graph.OperatorGraphFile;
import java.awt.Dialog;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.text.JTextComponent;

public final class Util {
    public static DefaultListModel createListModelFrom(List l) {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (Object o : l) {
            if (Module.class.isAssignableFrom(o.getClass())) {
                Module m = (Module)o;
                listModel.addElement(m.getName());
                continue;
            }
            listModel.addElement((String)o);
        }
        return listModel;
    }

    public static String configureModule(Dialog parent, Module mod, Schedule schedule) {
        if (mod != null && mod instanceof Configurable) {
            PropertyDialog pd = new PropertyDialog(parent, schedule.getEventController(), mod, schedule.getPossibleEventSources(), schedule.getBatchList());
            pd.setVisible(true);
            Configuration conf = ((Configurable)mod).getConfiguration();
            return conf.getDescription();
        }
        return "<not configurable>";
    }

    public static void displayText(JTextComponent tc, String s) {
        tc.setText(s);
        tc.setCaretPosition(0);
    }

    public static List getFitnessTransformersFrom(Schedule schedule) {
        ArrayList<FitnessTransformer> l = new ArrayList<FitnessTransformer>();
        FitnessFunction f = schedule.getFitnessFunction();
        if (f instanceof FitnessTransformer) {
            FitnessTransformer ft = (FitnessTransformer)f;
            while (ft != null) {
                l.add(ft);
                ft = ft.getFitnessFunction() instanceof FitnessTransformer ? (FitnessTransformer)ft.getFitnessFunction() : null;
            }
        }
        return l;
    }

    public static boolean scheduleStarted(Schedule schedule) {
        return !schedule.getCurrentTimeIndex().equals(GenerationIndex.START);
    }

    public static FreakGraphModel loadOperatorGraph(String fileName, Schedule schedule) {
        try {
            OperatorGraphFile ogFile = OperatorGraphFile.read(new FileInputStream(new File(fileName)));
            return ogFile.generateGraph(schedule);
        }
        catch (Exception exc) {
            System.out.println("Error loading graph " + fileName);
            return null;
        }
    }
}

